#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SP2ONG 2022 oled2svx

import time
from datetime import datetime
import math
import os

import subprocess

from adafruit_extended_bus import ExtendedI2C as I2C
i2c = I2C(0)

from PIL import Image, ImageDraw, ImageFont
import adafruit_ssd1306

disp = adafruit_ssd1306.SSD1306_I2C(128, 64, i2c)

# Contrast OLED values 1 -255
disp.contrast(255)
#
# time out for screen saver
screen_saver=20


# Clear display.
disp.fill(0)
disp.show()

# Create blank image for drawing.
# Make sure to create image with mode '1' for 1-bit color.
width = disp.width
height = disp.height
image = Image.new("1", (width, height))

# Get drawing object to draw on image.
draw = ImageDraw.Draw(image)

# Draw a black filled box to clear the image.
draw.rectangle((0, 0, width, height), outline=0, fill=0)

# Draw some shapes.
# First define some constants to allow easy resizing of shapes.
padding = -2
top = padding
bottom = height - padding
# Move left to right keeping track of the current x position for drawing shapes.
x = 0

# Load default font.
font = ImageFont.load_default()
# use custom font
font_path = str('/opt/oled/fonts/Roboto-Light.ttf')
font12 = ImageFont.truetype(font_path, 12)
font14 = ImageFont.truetype(font_path, 14)
font20 = ImageFont.truetype(font_path, 20)
font22 = ImageFont.truetype(font_path, 22)
#font = ImageFont.truetype(font_path, 16)
font18 = ImageFont.truetype(font_path, 18)

wan_interface = "eth0"
w24_interface = "wlan0"
w5G_interface = "wlan1"
vpn_interface = "lon"

globe = Image.open('images/globe.png').convert('1')
wifi  = Image.open('images/wifi.png').convert('1')
no_wifi = Image.open('images/no-wifi.png').convert('1')
vpn   = Image.open('images/vpn.png').convert('1')




def get_svxlog():
    f = os.popen('egrep -a -h "Talker start on|Talker stop on" /var/log/svxlink | tail -1')
    logsvx = str(f.read()).split(" ")
    if len(logsvx)>=2 and logsvx[4]=="start":
       CALL=logsvx[8].rstrip("\r\n")
       TalkG="TG "+logsvx[7].lstrip("#").rstrip(":")
    else:
       CALL=""
       TalkG=""
    return CALL,TalkG

def get_ip():
    cmd = "hostname -I | awk '{print $1}'"
    IP = subprocess.check_output(cmd, shell = True ).decode("utf-8")
    return "IP:  " + str(IP).rstrip("\r\n")+" "

def get_temp():
    # get cpu temperature
    try:
        with open("/sys/class/thermal/thermal_zone0/temp", "r") as temp:
            tmpCel = int(temp.read()[:2])
    except:
        tmpCel = 0
    finally:
        return "T "+str(tmpCel)+" C"
#        return "T "+str(tmpCel)+"°C"

def get_cpuL():
    cmd = "top -bn1 | grep load | awk '{printf \"CPU : L %.2f,\", $(NF-2)}'"
    CPUL = subprocess.check_output(cmd, shell = True ).decode("utf-8")
    return CPUL



# width in pixel screen
W=128

time_show="0"
count=0

while True:
    count =count+1

    # Draw a black filled box to clear the image.
    draw.rectangle((0,0,width,height), outline=0, fill=0)
    check_svx=get_svxlog()
    if check_svx[0]!="":
      time_show="0"
      count=0
      msg = str(check_svx[1])
      w,h = draw.textsize(msg,font=font20)
      draw.text(((W-w)/2, top+5),    msg,  font=font20, fill=255)
      msg = str(check_svx[0])
      w,h = draw.textsize(msg,font=font22)
      draw.text(((W-w)/2, top+28),    msg,  font=font22, fill=255)
    elif check_svx[0]=="" and count<screen_saver:
      now = datetime.now()
      current_time = now.strftime("    Uhrzeit: "+"%H:%M")
      msg = str(current_time)
      w,h = draw.textsize(msg,font=font14)
      draw.text((0,30),    msg,  font=font14, fill=255)
      draw.text((0,10), " no RX -wait- ",  font=font18, fill=255)
      time_show="1"
      Temp = get_temp()
      msg = str(Temp)
      draw.text((30,45), msg, font=font14, fill=255)

    if count<screen_saver:
      Temp = get_temp()
      CPUL = get_cpuL()

    # Screen saver
    if time_show=="1" and check_svx[0]=="" and count>screen_saver:
      try:
          with open("/sys/class/net/" + wan_interface + "/operstate") as f:
                  if f.read().strip() != "up":
                          throw
          image.paste(globe, (32 * 0, 0))
          msg = get_ip()
          draw.text((0, 30), msg,  font=font, fill=255)
      except:
          image.paste(no_wifi, (4, 0))
          draw.text((0, 16), " LAN",  font=font, fill=255)
############wifi  2,4 ghz  ##########
      draw.text((32 * 1, 16), "2.4G",  font=font, fill=255)
      try:
          with open("/sys/class/net/" + w24_interface + "/operstate") as f:
                  if f.read().strip() != "up":
                          throw
          image.paste(wifi, (32 * 1 + 4, 0))
      except:
          image.paste(no_wifi, (32 * 1 + 4, 0))
          msg = get_ip()
          draw.text((0, 30), msg,  font=font, fill=255)
############ wifi 5ghz ############
      draw.text((32 * 2, 16), "5GHz",  font=font, fill=255)
      try:
          with open("/sys/class/net/" + w5G_interface + "/operstate") as f:
                  if f.read().strip() != "up":
                          throw
          image.paste(wifi, (32 * 2 + 4, 0))
      except:
          image.paste(no_wifi, (32 * 2 + 4, 0))
          msg = get_ip()
          draw.text((0, 30), msg,  font=font, fill=255)
####################VPN-##########
      try:
          with open("/sys/class/net/" + vpn_interface + "/operstate") as f:
                  if f.read().strip() != "up":
                          throw
          image.paste(vpn, (32 * 3, 0))
      except:
              pass
####################  Temp und CPU -l###########

      msg = str(CPUL) + " "+str(Temp)
      draw.text((0,39), msg, font=font12, fill=255)
      now = datetime.now()
      current_time = now.strftime("    Uhrzeit: "+"%H:%M")
      msg = str(current_time)
      w,h = draw.textsize(msg,font=font12)
      draw.text((0,51),    msg,  font=font12, fill=255)






    # Display image.
    disp.image(image)
    disp.show()

   
    if time_show=="1" and count>screen_saver:
      time.sleep(0.05)
    else:
      time.sleep(0.25)

